%%
%% This is file `skdoc.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% skdoc.dtx  (with options: `class')
%% 
%% skdoc documentation class
%%
%% Copyright (C) 2012 by Simon Sigurdhsson <sigurdhsson@gmail.com>
%%
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   http://www.latex-project.org/lppl.txt
%% and version 1.3 or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%%
%% This work has the LPPL maintenance status `maintained'.
%%
%% The Current Maintainer of this work is Simon Sigurdhsson.
%%
%% This work consists of the files skdoc.dtx
%% and the derived filebase skdoc.cls.
\RequirePackage{expl3}
\ProvidesExplClass{skdoc}
    {2012/12/26}{1.0}{skdoc documentation class}
\PassOptionsToPackage{log-declarations=false}{xparse}
\LoadClass[ DIV7,
            headings=big,
            numbers=noenddot,
            abstracton,
            bibliography=totocnumbered,
            index=totoc
        ]{scrartcl}
\RequirePackage{etoolbox,xstring,xparse,atbegshi,kvoptions}
\RequirePackage{verbatim,marginnote,calc,hyperref,multicol,hologo}
\RequirePackage[nomain,xindy,numberedsection,order=letter,
                sanitize={description=false,sort=false}]{glossaries}
\RequirePackage{ydoc-code,ydoc-desc}
\RequirePackage[british]{babel}
\RequirePackage[english=british]{csquotes}
\RequirePackage[font=small,labelfont=bf,textfont=it]{caption}
\RequirePackage{scrpage2,PTSerif,ascii}
\RequirePackage[defaultsans,osfigures,scale=0.95]{opensans}
\RequirePackage[babel]{microtype}
\msg_new:nnn{skdoc}{key-exists}{File~key~"#1"~already~declared!}
\msg_new:nnn{skdoc}{key-nexists}{File~key~"#1"~hasn't~been~declared!}
\msg_new:nnn{skdoc}{wrote-file}{Writing~things~to~file~"#1".}
\msg_new:nnn{skdoc}{read-preamble}{Reading~preamble~from~file~"#1".}
\msg_new:nnn{skdoc}{no-lppl}{Could~not~include~LPPL:~lppl.tex~does~not~exist!}
\SetupKeyvalOptions{
    family=skdoc,
    prefix=skdoc@
}
\DeclareStringOption{load}[\jobname]
\ProcessKeyvalOptions*
\IfStrEq{\skdoc@load}{}{}{%
    \IfFileExists{\skdoc@load.sty}{%
        \RequirePackage{\skdoc@load}
    }{}
}
\tl_new:N\skdoc@temptl
\ior_new:N\skdoc@input
\iow_new:N\skdoc@output
\DeclareDocumentCommand\DeclareFile{om}{
    \group_begin:
    \keys_define:nn{skdoc@declarefile}{%
        preamble .value_required:,
        preamble .code:n = \edef\skdoc@preamble{##1},
        key .value_required:,
        key .code:n = \def\skdoc@key{##1}
    }%
    \def\skdoc@preamble{}%
    \def\skdoc@key{#2}%
    \IfNoValueTF{#1}{}{\keys_set:nn{skdoc@declarefile}{#1}}
    \tl_new:c{skdoc@output@\skdoc@key}
    \int_if_exist:cTF{skdoc@output@\skdoc@key @line}{
        \msg_critical:nnx{skdoc}{key-exists}{\skdoc@key}
    }{
        \int_zero_new:c{skdoc@output@\skdoc@key @line}
    }
    \IfStrEq{\skdoc@preamble}{}{}{
        \tl_set:Nx\l_tmpa_tl{\skdoc@preamble}
        \edef\skdoc@temp{\tl_head:N\l_tmpa_tl}
        \def\skdoc@preamble@extra{
            \skdoc@temp\skdoc@temp\space~This~is~file~`#2',~generated~from~`\c_job_name_tl.tex'~(key~`\skdoc@key').
        }
    }
    \expandafter\xdef\csname skdoc@write@#2\endcsname{%
        \noexpand\msg_log:nnn{skdoc}{wrote-file}{#2}
        \noexpand\iow_open:Nn\noexpand\skdoc@output{#2}
        \noexpand\IfStrEq{\skdoc@preamble}{}{}{
            \noexpand\iow_now:Nx\noexpand\skdoc@output{\skdoc@preamble@extra}
            \noexpand\iow_now:Nx\noexpand\skdoc@output{\skdoc@preamble}
        }
        \noexpand\iow_now:Nx\noexpand\skdoc@output{\noexpand\tl_to_str:c{skdoc@output@\skdoc@key}}
        \noexpand\iow_close:N\noexpand\skdoc@output
    }
    \AfterEndDocument{\csname skdoc@write@#2\endcsname}
    \group_end:
}
\DeclareDocumentEnvironment{skdoc@verbatim}{m}{%
    \iftoggle{skdoc@impl}{\@bsphack}{}
    \def\skdoc@key{#1}
    \int_if_exist:cTF{skdoc@output@\skdoc@key @line}{}{
        \msg_critical:nnx{skdoc}{key-nexists}{\skdoc@key}
    }%
    \marginnote{
        \leavevmode
        \llap{
            \scriptsize\color{gray}
            $\langle$\skdoc@key$\rangle$
            \makebox[2ex]{\strut}
        }
    }
    \def\verbatim@processline{%
        \tl_gput_right:cx{skdoc@output@\skdoc@key}{\the\verbatim@line\iow_newline:}%
        \int_gincr:c{skdoc@output@\skdoc@key @line}%
        \iftoggle{skdoc@impl}{
            \noindent\leavevmode%
            \hspace*{-5ex}
            \begin{minipage}[c][1ex]{\textwidth}
                \makebox[4ex]{%
                    \leavevmode
                    \tiny\color{lightgray}\hfill%
                    \int_use:c{skdoc@output@\skdoc@key @line}%
                }%
                \hspace*{1ex}%
                {
                    \verbatim@font\footnotesize
                    \the\verbatim@line
                }
            \end{minipage}
            \vskip-.75ex\par
        }{}
    }%
    \let\do\@makeother\dospecials\catcode`\^^M\active%
    \iftoggle{skdoc@impl}{
        \frenchspacing\@vobeyspaces
    }{}
    \verbatim@start%
}{%
    \iftoggle{skdoc@impl}{\@esphack}{}%
}
\DeclareDocumentEnvironment{MacroCode}{m}{
    \iftoggle{skdoc@impl}{
        \vspace{.2\baselineskip}
        \par\noindent
    }{}
    \skdoc@verbatim{#1}
}{
    \endskdoc@verbatim
    \iftoggle{skdoc@impl}{
        \vspace{.5\baselineskip}
    }{}
}
\DeclareDocumentCommand\PreambleTo{mm}{%
    \group_begin:
    \msg_info:nnn{skdoc}{read-preamble}{#2}
    \ior_open:Nn\skdoc@input{#2}
    \bool_until_do:nn{\ior_if_eof_p:N\skdoc@input}{%
        \tl_if_empty:NTF\skdoc@temptl{}{%
            \tl_put_right:Nx\skdoc@temptl{\iow_newline:}
        }
        \tl_clear:N\l_tmpb_tl
        \ior_get_str:NN\skdoc@input\l_tmpa_tl
        \tl_put_right:Nx\l_tmpb_tl{\tl_head:N\l_tmpa_tl}
        \IfStrEq{\tl_to_str:N\l_tmpb_tl}{\@percentchar}{%
            \tl_set_eq:NN\l_tmpb_tl\skdoc@temptl
            \tl_concat:NNN\skdoc@temptl\l_tmpb_tl\l_tmpa_tl
        }{%
            \ior_close:N\skdoc@input
        }
    }
    \xdef#1{\tl_to_str:N\skdoc@temptl}
    \group_end:
}
\DeclareDocumentCommand\SelfPreambleTo{m}{%
    \PreambleTo{#1}{\c_job_name_tl}%
}
\definecolorset{RGB}{}{}{
    section,11,72,107;
    extlink,73,10,61;
    intlink,140,35,24;
    sharp,250,105,0;
    bright,198,229,217;
    macrodesc,73,10,61;
    keydesc,140,35,24;
    macroimpl,73,10,61;
    meta,11,72,107;
    scriptcolor,140,35,24;
    optioncolor,73,10,61;
    opt,73,10,61
}
\RenewDocumentCommand\descfont{}{\sffamily\fontseries{sb}}
\RenewDocumentCommand\sectfont{}{\sffamily\fontseries{sb}}
\addtokomafont{minisec}{\bfseries}
\addtokomafont{paragraph}{\color{section}}
\addtokomafont{section}{\color{section}}
\addtokomafont{subsection}{\color{section}}
\addtokomafont{subsubsection}{\color{section}}
\addtokomafont{descriptionlabel}{\color{section}}
\addtokomafont{sectionentry}{\rmfamily\bfseries}
\addtokomafont{sectionentrypagenumber}{\rmfamily\bfseries}
\hypersetup{
    colorlinks=true,
    linkcolor=intlink,
    anchorcolor=intlink,
    citecolor=black,
    urlcolor=extlink
}
\newtoggle{skdoc@noindex}
\togglefalse{skdoc@noindex}
\DeclareDocumentCommand\cs{sm}{
    \texttt{\char`\\#2}
    \iftoggle{skdoc@noindex}{}{
        \IfBooleanTF{#1}{}{\index@macro{#2}}
    }
}
\DeclareDocumentCommand\env{sm}{
    \texttt{#2}
    \iftoggle{skdoc@noindex}{}{
        \IfBooleanTF{#1}{}{\index@environment{#2}}
    }
}
\DeclareDocumentCommand\pkg{sm}{
    \textsf{#2}
    \iftoggle{skdoc@noindex}{}{
        \IfBooleanTF{#1}{}{\index@package{#2}}
    }
}
\DeclareDocumentCommand\opt{sm}{
    \texttt{#2}
    \iftoggle{skdoc@noindex}{}{
        \IfBooleanTF{#1}{}{\index@option{#2}}
    }
}
\DeclareDocumentCommand\bib{sm}{
    \texttt{@#2}
    \iftoggle{skdoc@noindex}{}{
        \IfBooleanTF{#1}{}{\index@bibentry{#2}}
    }
}
\DeclareDocumentCommand\thm{sm}{
    \textrm{#2}
    \iftoggle{skdoc@noindex}{}{
        \IfBooleanTF{#1}{}{\index@theme{#2}}
    }
}
\DeclareDocumentCommand\file{sm}{
    \texttt{#2}
    \iftoggle{skdoc@noindex}{}{
        \IfBooleanTF{#1}{}{\index@file{#2}}
    }
}
\def\Describe@Macro#1{%
    \endgroup
    \edef\name{\expandafter\@gobble\string#1}%
    \global\@namedef{href@desc@\name}{}%
    \immediate\write\@mainaux{%
        \global\noexpand\@namedef{href@desc@\name}{}%
    }%
    \hbox\y@bgroup
    \@ifundefined{href@impl@\name}{}{\hyperlink{impl:\name}}%
    {%
        \hbox{
            \vbox to 0pt{
                \vss\hbox{
                    \raisebox{4ex}{\hypertarget{desc:\name}{}
                }
            }
        }%
        \marginnote{\llap{\PrintMacroName{#1}}}
        }%
    }%
    \ydoc@macrocatcodes
    \macroargsstyle
    \read@Macro@arg
}
\def\descframe#1{%
    \mbox{\hspace*{1.5\descsep}#1\hspace*{2\descsep}}%
}
\let\old@PrintMacroName\PrintMacroName
\DeclareDocumentCommand\PrintMacroName{m}{%
    \index@macro*{\expandafter\@gobble\string#1}
    \old@PrintMacroName{#1}
}
\let\old@PrintEnvName\PrintEnvName
\def\PrintEnvName#1#2{
    \ifx#1\begin
        \edef\skdoc@temp{\noexpand\index@environment*{#2}}
        \skdoc@temp
    \fi
    \old@PrintEnvName{#1}{#2}
}
\DeclareDocumentCommand\DescribeEnv{om}{
    \medskip\par\noindent
    \marginnote{
        \envcodestyle
        \hfill\llap{\PrintEnvName{\begin}{#2}}\mbox{}\\
        \IfNoValueTF{#1}{}{\hfill\llap{\MacroArgs#1}\mbox{}\\}
        \hfill\llap{\PrintEnvName{\end}{#2}}\mbox{}\\
    }
    \begingroup
    \def\after@Macro@args{\endDescribeEnv}
    \y@bgroup
    \ydoc@macrocatcodes
    \macroargsstyle
    \read@Macro@arg
}
\DeclareDocumentCommand\endDescribeEnv{}{
    \endgroup
    \smallskip\par\noindent
}
\let\optpar\relax
\DeclareDocumentCommand\Options{m}{
    \clist_set:Nn\l_tmpa_clist{#1}
    \marginnote{
        \clist_map_inline:Nn\l_tmpa_clist{
            \index@option*{####1}
            \hfill
            \llap{\textcolor{opt}{\opt{####1}}}
            \mbox{}\\
        }
    }
    \nobreak
}
\DeclareDocumentCommand\Option{m}{
    \Options{#1}
}
\def\skdoc@WithValues@peek{
    \ifx\@let@token\AndDefault\else\par\noindent\nobreak\fi
}
\DeclareDocumentCommand\WithValues{m}{
    \noindent\makebox[\linewidth][l]{\texttt{#1}}
    \futurelet\@let@token\skdoc@WithValues@peek
}
\DeclareDocumentCommand\AndDefault{m}{
    \llap{\textcolor{gray}{\texttt{(#1)}}}\par\noindent\nobreak
}
\DeclareDocumentCommand\BibEntry{m}{
    \marginnote{
        \index@bibentry*{#1}
        \hfill\llap{\textcolor{macrodesc}{\bib{#1}}}
    }
    \nobreak
}
\DeclareDocumentCommand\WithFields{om}{
    \noindent\makebox[\linewidth]{
        \texttt{#2}
        \IfNoValueTF{#1}{}{
            \textcolor{gray}{\texttt{,#2}}
        }
    }
    \par\noindent\nobreak
}
\DeclareDocumentCommand\Theme{m}{
    \marginnote{
        \index@theme*{#1}
        \hfill\llap{\textcolor{macrodesc}{\thm{#1}}}
    }
    \nobreak\par\noindent\nobreak
}
\DeclareDocumentCommand\DescribeFile{m}{
    \marginnote{
        \index@file*{#1}
        \hfill\llap{\textcolor{macrodesc}{\file{#1}}}
    }
    \nobreak\par\noindent\nobreak
}
\DeclareDocumentEnvironment{example}{}{
    \minisec{Example:}
}{}
\DeclareDocumentEnvironment{macro}{smo}{%
    \@bsphack
    \index@macro!{\expandafter\@gobble\string#2}
    \@macroname{#2}%
    \IfBooleanTF{#1}{
        \IfNoValueTF{#3}{}{
            \int_compare:nNnTF{#3}>{0}{
                \cs:w use_none:\prg_replicate:nn{#3}{n}\cs_end:
            }{}
        }
    }{
        \PrintMacroImpl{#2}
        \IfNoValueTF{#3}{
            \macro@impl@argline@noarg{(no~arguments)}
        }{\macro@impl@args[#3]}
    }%
}{
    \let\skdoc@macroname@key\@empty
    \IfBooleanTF{#1}{}{\@esphack}
}
\DeclareDocumentEnvironment{environment}{smo}{%
    \@bsphack
    \index@environment!{#2}
    \@environmentname{#2}%
    \IfBooleanTF{#1}{
        \IfNoValueTF{#3}{}{
            \int_compare:nNnTF{#3}>{0}{
                \cs:w use_none:\prg_replicate:nn{#3}{n}\cs_end:
            }{}
        }
    }{
        \PrintEnvImplName{#2}
        \IfNoValueTF{#3}{
            \macro@impl@argline@noarg{(no~arguments)}
        }{\macro@impl@args[#3]}
    }%
}{
    \let\skdoc@macroname@key\@empty
    \IfBooleanTF{#1}{}{\@esphack}
}
\DeclareDocumentEnvironment{option}{smg}{%
    \@bsphack
    \index@option!{#2}
    \@optionname{#2}%
    \IfBooleanTF{#1}{}{
        \PrintEnvImplName{#2}
        \IfNoValueTF{#3}{
            \macro@impl@argline@noarg{(option)}
        }{
            \macro@impl@argline@noarg{
                Option~with~values~\texttt{\textcolor{gray}{#3}}
            }
        }
    }%
}{
    \let\skdoc@macroname@key\@empty
    \IfBooleanTF{#1}{}{\@esphack}
}
\DeclareDocumentEnvironment{bibentry}{sm}{%
    \@bsphack
    \index@bibentry!{\expandafter\@gobble\string#2}
    \@bibentryname{#2}%
    \IfBooleanTF{#1}{}{
        \PrintEnvImplName{#2}
        \macro@impl@argline@noarg{(\hologoRobust{BibTeX}~entry~type)}
    }%
}{
    \let\skdoc@macroname@key\@empty
    \IfBooleanTF{#1}{}{\@esphack}
}
\DeclareDocumentEnvironment{theme}{sm}{%
    \@bsphack
    \index@theme!{#2}
    \@themename{#2}%
    \IfBooleanTF{#1}{}{
        \PrintEnvImplName{#2}
        \macro@impl@argline@noarg{(theme)}
    }%
}{
    \let\skdoc@macroname@key\@empty
    \IfBooleanTF{#1}{}{\@esphack}
}
\DeclareDocumentEnvironment{macro*}{mo}%
    {\begin{macro}*{#1}[#2]}{\end{macro}}
\DeclareDocumentEnvironment{environment*}{mo}%
    {\begin{environment}*{#1}[#2]}{\end{environment}}
\DeclareDocumentEnvironment{option*}{mg}%
    {\begin{option}*{#1}{#2}}{\end{option}}
\DeclareDocumentEnvironment{bibentry*}{m}%
    {\begin{bibentry}*{#1}}{\end{bibentry}}
\DeclareDocumentEnvironment{theme*}{m}%
    {\begin{theme}*{#1}}{\end{theme}}
\def\PrintEnvImplName#1{%
    \par\mbox{}
    \marginnote{\llap{\implstyle{#1}}}
    \par
}
\def\PrintMacroImpl#1{%
    \par
    \hbox{%
        \edef\name{\expandafter\@gobble\string#1}%
        \global\@namedef{href@impl@\name}{}%
        \immediate\write\@mainaux{%
            \global\noexpand\@namedef{href@impl@\name}{}%
        }%
        \raisebox{4ex}[4ex]{\hypertarget{impl:\name}{}}%
        \@ifundefined{href@desc@\name}{}{\hyperlink{desc:\name}}%
        \marginnote{\llap{\PrintMacroImplName{#1}}}%
    }%
    \par
}
\def\macro@impl@argline#1#2{%
    \par\noindent{\texttt{\##1}:~#2\strut}%
}
\def\macro@impl@args[#1]{%
    \vspace*{-\baselineskip}
    \begingroup
    \let\macro@impl@argcnt\@tempcnta
    \let\macro@impl@curarg\@tempcntb
    \macro@impl@argcnt=#1\relax
    \macro@impl@curarg=0\relax
    \ifnum\macro@impl@curarg<\macro@impl@argcnt\relax
        \expandafter\macro@impl@arg
    \else
        \expandafter\macro@impl@endargs
    \fi
}
\def\macro@impl@endargs{
    \endgroup\par
}
\def\macro@impl@argline@noarg#1{%
    \vspace*{-\baselineskip}
    \par\noindent{#1\strut}\par\medskip%
}
\prg_new_conditional:Nnn\__skdoc_do_index:{p}{
    \iftoggle{skdoc@impl}{
        \prg_return_true:
    }{
        \iftoggle{skdoc@in@impl}{
            \prg_return_false:
        }{
            \prg_return_true:
        }
    }
}
\DeclareDocumentCommand\@index@{mm}{
    \if_predicate:w\__skdoc_do_index_p:
        \@index@@{#1}{#2}
    \fi:
}
\DeclareDocumentCommand\@index@@{mm}{
    \newglossaryentry{index-#1}{
        type=index,
        name={#2},
        description={\nopostdesc},
        sort={#1}
    }
}
\DeclareDocumentCommand\index@macro{st!m}{
    \def\skdoc@temp{#3}
    \ifglsentryexists{index-\skdoc@temp}{}{
        \@index@{#3}{\cs*{#3}}
    }
    \if_predicate:w\__skdoc_do_index_p:
        \IfBooleanTF{#2}{
            \glsadd[types=index,format=hyperul]{index-\skdoc@temp}
        }{
            \IfBooleanTF{#1}{
                \glsadd[types=index,format=hyperit]{index-\skdoc@temp}
            }{
                \glsadd[types=index]{index-\skdoc@temp}
            }
        }
    \fi:
}
\DeclareDocumentCommand\index@environment{st!m}{
    \def\skdoc@temp{\string#3}
    \ifglsentryexists{index-\skdoc@temp}{}{
        \@index@{\string#3}{\env*{\string#3}~(environment)}
    }
    \if_predicate:w\__skdoc_do_index_p:
        \IfBooleanTF{#2}{
            \glsadd[types=index,format=hyperul]{index-\skdoc@temp}
        }{
            \IfBooleanTF{#1}{
                \glsadd[types=index,format=hyperit]{index-\skdoc@temp}
            }{
                \glsadd[types=index]{index-\skdoc@temp}
            }
        }
    \fi:
}
\DeclareDocumentCommand\index@option{st!m}{
    \def\skdoc@temp{\string#3}
    \ifglsentryexists{index-\skdoc@temp}{}{
        \@index@{\string#3}{\opt*{\string#3}~(option)}
    }
    \if_predicate:w\__skdoc_do_index_p:
        \IfBooleanTF{#2}{
            \glsadd[types=index,format=hyperul]{index-\skdoc@temp}
        }{
            \IfBooleanTF{#1}{
                \glsadd[types=index,format=hyperit]{index-\skdoc@temp}
            }{
                \glsadd[types=index]{index-\skdoc@temp}
            }
        }
    \fi:
}
\DeclareDocumentCommand\index@bibentry{st!m}{
    \def\skdoc@temp{#3}
    \ifglsentryexists{index-\skdoc@temp}{}{
        \@index@{#3}{\bib*{#3}~(\hologoRobust{BibTeX}~entry~type)}
    }
    \if_predicate:w\__skdoc_do_index_p:
        \IfBooleanTF{#2}{
            \glsadd[types=index,format=hyperul]{index-\skdoc@temp}
        }{
            \IfBooleanTF{#1}{
                \glsadd[types=index,format=hyperit]{index-\skdoc@temp}
            }{
                \glsadd[types=index]{index-\skdoc@temp}
            }
        }
    \fi:
}
\DeclareDocumentCommand\index@theme{st!m}{
    \def\skdoc@temp{\string#3}
    \ifglsentryexists{index-\skdoc@temp}{}{
        \@index@{\string#3}{\thm*{\string#3}~(theme)}
    }
    \if_predicate:w\__skdoc_do_index_p:
        \IfBooleanTF{#2}{
            \glsadd[types=index,format=hyperul]{index-\skdoc@temp}
        }{
            \IfBooleanTF{#1}{
                \glsadd[types=index,format=hyperit]{index-\skdoc@temp}
            }{
                \glsadd[types=index]{index-\skdoc@temp}
            }
        }
    \fi:
}
\DeclareDocumentCommand\index@package{st!m}{
    \def\skdoc@temp{\string#3}
    \ifglsentryexists{index-\skdoc@temp}{}{
        \@index@{\string#3}{\pkg*{\string#3}~(package)}
    }
    \if_predicate:w\__skdoc_do_index_p:
        \IfBooleanTF{#2}{
            \glsadd[types=index,format=hyperul]{index-\skdoc@temp}
        }{
            \IfBooleanTF{#1}{
                \glsadd[types=index,format=hyperit]{index-\skdoc@temp}
            }{
                \glsadd[types=index]{index-\skdoc@temp}
            }
        }
    \fi:
}
\DeclareDocumentCommand\index@file{st!m}{
    \def\skdoc@temp{\string#3}
    \ifglsentryexists{index-\skdoc@temp}{}{
        \@index@{\string#3}{\file*{\string#3}~(file)}
    }
    \if_predicate:w\__skdoc_do_index_p:
        \IfBooleanTF{#2}{
            \glsadd[types=index,format=hyperul]{index-\skdoc@temp}
        }{
            \IfBooleanTF{#1}{
                \glsadd[types=index,format=hyperit]{index-\skdoc@temp}
            }{
                \glsadd[types=index]{index-\skdoc@temp}
            }
        }
    \fi:
}
\ProvideDocumentCommand\hyperul{m}{
    \underline{\hyperup{#1}}
}
\newglossarystyle{docindex}{
    \glossarystyle{indexgroup}
    \renewcommand*{\glspostdescription}{\unskip\leaders\hbox to 2.9mm{\hss.}\hfill\strut}
    \renewenvironment{theglossary}{
        \toggletrue{skdoc@noindex}
        \begin{multicols}{2}
        \setlength{\parindent}{0pt}
        \setlength{\parskip}{0pt plus 0.3pt}
        \let\item\@idxitem
    }{
        \end{multicols}
        \togglefalse{skdoc@noindex}
    }
    \renewcommand*{\glossaryentryfield}[5]{
        \item\glsentryitem{##1}\glstarget{##1}{##2}
            \ifx\relax##4\relax\else\space(##4)\fi
            ##3\glspostdescription\space ##5}
    \renewcommand*{\glsgroupheading}[1]{
        \IfStrEq{##1}{default}{
            \item{\descfont\glssymbolsgroupname}
        }{
            \item{\descfont\glsgetgrouptitle{##1}}
        }
    }
    \renewcommand*{\glsgroupskip}{
        \par\vspace{15\p@}\relax
    }
}
\newglossary{index}{ids}{ido}{Index}
\AtBeginDocument{\makeglossaries}
\providecommand*\PrintIndex{%
    \begingroup
    \renewcommand*{\glossarypreamble}{
        Numbers~written~in~boldface~refer~to~the~page~where~the~
        corresponding~entry~is~described;~numbers~underlined~refer~
        to~the~page~were~the~implementation~of~the~corresponding~
        entry~is~discussed.~Numbers~in~roman~refer~to~other~
        mentions~of~the~entry.\par
    }
    \printglossary[type=index,style=docindex]
    \endgroup
}
\RenewDocumentCommand\@gls@addpredefinedattributes{}{
    \GlsAddXdyAttribute{hyperit}
    \GlsAddXdyAttribute{hyperul}
    \GlsAddXdyAttribute{glsnumberformat}
}
\DeclareDocumentCommand\generalname{}{General}
\DeclareDocumentCommand\@macroname{m}{
    \def\skdoc@macroname@stylized{\cs*{\expandafter\@gobble\string#1}}
    \def\skdoc@macroname@key{macro-\expandafter\@gobble\string#1}
}
\DeclareDocumentCommand\@environmentname{m}{
    \def\skdoc@macroname@stylized{\env*{\string#1}}
    \def\skdoc@macroname@key{env-#1}
}
\DeclareDocumentCommand\@optionname{m}{
    \def\skdoc@macroname@stylized{\opt*{\string#1}}
    \def\skdoc@macroname@key{opt-#1}
}
\DeclareDocumentCommand\@bibentryname{m}{
    \def\skdoc@macroname@stylized{\bib*{\expandafter\@gobble\string#1}}
    \def\skdoc@macroname@key{bibentry-\expandafter\@gobble\string#1}
}
\DeclareDocumentCommand\@themename{m}{
    \def\skdoc@macroname@stylized{\thm*{\string#1}}
    \def\skdoc@macroname@key{thm-#1}
}
\def\skdoc@macroname@stylized{}
\let\skdoc@macroname@key\@empty
\DeclareDocumentCommand\changes{mm}{%
    \@bsphack
    \ifglsentryexists{#1}{}{
        \newglossaryentry{#1}{
            type=changes,
            name={v#1},
            description={\nopostdesc},
            nonumberlist=true
        }
    }
    \ifx\skdoc@macroname@key\@empty
        \newglossaryentry{#1-general}{
            type=changes,
            description={\generalname{}:~#2},
            parent={#1},
            sort={0},
            nonumberlist=true
        }
        \glsadd[types=changes]{#1-general}
    \else
        \newglossaryentry{#1-\skdoc@macroname@key}{
            type=changes,
            description={\skdoc@macroname@stylized{}:~#2},
            parent={#1},
            sort={\skdoc@macroname@key},
            nonumberlist=true
        }
        \glsadd[types=changes]{#1-\skdoc@macroname@key}
    \fi
    \@esphack
}
\newglossarystyle{changelog}{
    \glossarystyle{altlist}
    \renewenvironment{theglossary}{
        \toggletrue{skdoc@noindex}
        \begin{multicols}{2}\begin{description}
    }{
        \end{description}\end{multicols}
        \togglefalse{skdoc@noindex}
    }
    \renewcommand*{\glossaryentryfield}[5]{
        \par\vspace{5\p@}\relax
        \item[\glsentryitem{##1}\glstarget{##1}{##2}]
                    \mbox{}\par\nobreak\@afterheading
    }
    \renewcommand{\glossarysubentryfield}[6]{%
        \par\hspace*{\itemindent}
        \glssubentryitem{##2}%
        \glstarget{##2}{\strut}##4\glspostdescription\space ##6
    }
}
\newglossary{changes}{gls}{glo}{Changes}
\AtBeginDocument{\makeglossaries}
\DeclareDocumentCommand\PrintChanges{}{%
    \begingroup
    \printglossary[type=changes,style=changelog]
    \endgroup
}
\newtoggle{skdoc@impl}
\newtoggle{skdoc@in@impl}
\toggletrue{skdoc@impl}
\togglefalse{skdoc@in@impl}
\newcounter{skdoc@impl@page}
\AtBeginShipout{
    \iftoggle{skdoc@impl}{}{
        \iftoggle{skdoc@in@impl}{\AtBeginShipoutDiscard}{}
    }
}
\DeclareDocumentCommand\OnlyDescription{}{\togglefalse{skdoc@impl}}
\DeclareDocumentCommand\Implementation{}{
    \iftoggle{skdoc@impl}{}{
        \clearpage
        \toggletrue{skdoc@in@impl}
        \let\skdoc@old@part\part
        \DeclareDocumentCommand\part{som}{}
        \let\skdoc@old@section\section
        \DeclareDocumentCommand\section{som}{}
        \let\skdoc@old@subsection\subsection
        \DeclareDocumentCommand\subsection{som}{}
        \let\skdoc@old@subsubsection\subsubsection
        \DeclareDocumentCommand\subsubsection{som}{}
        \let\skdoc@old@paragraph\paragraph
        \DeclareDocumentCommand\paragraph{som}{}
        \let\skdoc@old@subparagraph\subparagraph
        \DeclareDocumentCommand\subparagraph{som}{}
        \setcounter{skdoc@impl@page}{\value{page}}
    }
}
\DeclareDocumentCommand\Finale{}{
    \iftoggle{skdoc@impl}{}{
        \clearpage
        \togglefalse{skdoc@in@impl}
        \let\part\skdoc@old@part
        \let\section\skdoc@old@section
        \let\subsection\skdoc@old@subsection
        \let\subsubsection\skdoc@old@subsubsection
        \let\paragraph\skdoc@old@paragraph
        \let\subparagraph\skdoc@old@subparagraph
        \setcounter{page}{\value{skdoc@impl@page}}
    }
}
\let\@ctan\@empty%
\let\@repository\@empty%
\let\@plainemail\@empty%
\let\@email\@empty%
\let\@version\@empty%
\DeclareDocumentCommand\package{om}{%
    \keys_define:nn{skdoc@package}{%
        vcs .value_required:,%
        vcs .code:n = \repository{##1},%
        ctan .code:n = \ctan{##1},%
        ctan .default:n = #2%
    }%
    \IfNoValueTF{#1}{}{\keys_set:nn{skdoc@package}{#1}}%
    \def\@package{#2}%
    \title{The~\textbf{\pkg*{\@package}}~package}%
}
\DeclareDocumentCommand\ctan{m}{%
    \def\@ctan{\url{http://www.ctan.org/pkg/#1}}%
}
\DeclareDocumentCommand\repository{m}{%
    \def\@repository{\url{#1}}%
}
\DeclareDocumentCommand\email{m}{%
    \def\@plainemail{#1}%
    \def\@email{\href{mailto:\@plainemail}{\@plainemail}}%
}
\DeclareDocumentCommand\version{m}{%
    \def\@version{#1}%
}
\package{\jobname}
\DeclareDocumentCommand\theversion{}{v\@version}
\DeclareDocumentCommand\thepackage{}{\pkg*{\@package}}
\DeclareDocumentCommand\thepkg{}{\thepackage}
\ifpdf
    \def\skdocpdfsettings{%
        \hypersetup{%
            pdfauthor   = {\@author\space<\@plainemail>},
            pdftitle    = {\@title},
            pdfsubject  = {Documentation~of~LaTeX~package~\@package},
            pdfkeywords = {\@package,~LaTeX,~TeX}
        }%
    }%
\else
    \let\skdocpdfsettings\empty%
\fi
\DeclareDocumentCommand\Notice{m}{
    (\emph{\textbf{Note:}~#1})
}
\DeclareDocumentCommand\Warning{+m}{
    \vspace{\baselineskip}
    \par\noindent
    \fbox{\begin{minipage}[c]{\textwidth}
        \centering
        \textbf{Warning:}~#1
    \end{minipage}}
    \vspace{\baselineskip}
    \par
}
\DeclareDocumentCommand\LongWarning{+m}{
    \Warning{
        \par\noindent
        \begin{minipage}{\textwidth}
            #1
        \end{minipage}
    }
}
\def\@maketitle{%
    \newpage
    \null
    \begin{flushleft}%
    {%
        \Huge\sectfont\@title%
        \ifx\@ctan\@empty\else%
            \footnote{Available~on~\@ctan.}%
        \fi
        \ifx\@repository\@empty\else%
            \footnote{Development~version~available~on~\@repository.}%
        \fi%
        \par%
    }%
    \vskip 1em
    {%
        \Large\@author
        \ifx\@email\@empty\else%
            \space
            \newlength\skdoc@minipage@ew%
            \settowidth{\skdoc@minipage@ew}{%
                \normalsize{$\lceil${\@email}$\rfloor$}}
            \begin{minipage}[b]{\skdoc@minipage@ew}
                \normalsize{$\lceil${\@email}$\rfloor$}
            \end{minipage}\par%
        \fi%
    }%
    \ifx\@version\@empty\else
        \vskip .5em
        {%
            \large Version~\@version\par%
        }%
    \fi
    \end{flushleft}%
    \par\bigskip%
}
\def\maketitle{%
    \begingroup
    \skdocpdfsettings
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}
    \@maketitle
    \setcounter{footnote}{0}
    \skdocpdfsettings
    \endgroup
}
\DeclareDocumentEnvironment{abstract}{}{
    \newlength\skdoc@abstract@tw%
    \newlength\skdoc@abstract@aw%
    \settowidth{\skdoc@abstract@tw}{\descfont\abstractname}%
    \setlength{\skdoc@abstract@aw}{\the\textwidth-\the\skdoc@abstract@tw-2em}%
    \begin{minipage}{\textwidth}
        \begin{minipage}[t]{\skdoc@abstract@tw}%
            \begin{flushright}%
                \leavevmode\descfont\abstractname%
            \end{flushright}%
        \end{minipage}%
        \hspace{1em}%
        \begin{minipage}[t]{\skdoc@abstract@aw}%
}{
        \end{minipage}
    \end{minipage}
}
\let\l@section@\l@section
\def\l@section{\vskip -.75ex\l@section@}
\def\l@subsection{\vskip.35ex\penalty\@secpenalty\@dottedtocline{2}{1.5em}{2.7em}}
\def\l@subsubsection#1#2{
    \leftskip 4.2em
    \parindent 0pt
    {\let\numberline\@gobble{\small #1~[#2]}}
}
\def\l@table{\@dottedtocline{1}{0pt}{1.5em}}
\def\l@figure{\@dottedtocline{1}{0pt}{1.5em}}
\def\@pnumwidth{1.7em}
\AtEndDocument{\addtocontents{toc}{\par}}
\let\old@tableofcontents\tableofcontents
\DeclareDocumentCommand\tableofcontents{}{
    \toggletrue{skdoc@noindex}
    \microtypesetup{protrusion=false}
    \old@tableofcontents
    \microtypesetup{protrusion=true}
    \togglefalse{skdoc@noindex}
}
\DeclareDocumentCommand\PrintLPPL{}{
    \begingroup
    \IfFileExists{lppl.tex}{
        \let\old@verbatim@font\verbatim@font
        \def\verbatim@font{
            \old@verbatim@font\tiny
        }
        \def\LPPLicense{\begingroup\small}
        \def\endLPPLicense{\endmulticols\endgroup}
        \DeclareDocumentCommand\LPPLsection{m}{
            \section{####1}
        }
        \DeclareDocumentCommand\skdoc@lppl@hack{m}{
            \end{multicols}
            \begin{multicols}{2}
                [\subsection*{####1}][6\baselineskip]
        }
        \DeclareDocumentCommand\LPPLsubsection{m}{
            \subsection*{####1}
            \let\LPPLsubsection\skdoc@lppl@hack
            \begin{multicols}{2}
        }
        \DeclareDocumentCommand\LPPLsubsubsection{m}{
            \subsubsection*{####1}
        }
        \DeclareDocumentCommand\LPPLparagraph{m}{\paragraph*{####1}}
        \DeclareDocumentCommand\LPPLfile{m}{\file{####1}}
        \let\oldmakeatletter\makeatletter
        \long\def\makeatletter####1\makeatother{
            \let\makeatletter\oldmakeatletter
        }
        \setlength\leftmargini{15pt}
        \setlength\leftmarginii{12.5pt}
        \setlength\leftmarginiii{10pt}
        \newenvironment{enum}[1][0]{
            \list\labelenumi{
                \usecounter{enumi}
                \setcounter{enumi}{####1}
                \addtocounter{enumi}{-1}
                \leftmargin 30pt
                \itemindent-15pt
                \labelwidth 15pt
                \labelsep 0pt
                \def\makelabel########1{########1\hss}}
        }{\endlist}
        \input{lppl}
    }{
        \msg_warning:nn{skdoc}{no-lppl}
    }
    \endgroup
}
\deftripstyle{skdoc}%
    {}{}{}%
    {\small The~\textbf{\pkg*{\@package}}~package,~v\@version}{}{\small\pagemark}
\AfterBeginDocument{\pagestyle{skdoc}}
\RenewDocumentCommand{\othersectionlevelsformat}{m}{%
    \makebox[0pt][r]{%
    \fontfamily{fos}\mdseries\selectfont
    \csname the#1\endcsname\enskip}%
}
\g@addto@macro\@verbatim{\microtypesetup{activate=false}}
\microtypesetup{expansion,kerning,spacing,tracking}
\DisableLigatures{family = tt*}
\AtBeginDocument{
    \ifdefined\defbibheading
        \defbibheading{bibliography}[\bibname]{\section{#1}}
    \fi
}
\AtBeginDocument{\reversemarginpar}
\endinput
%%
%% End of file `skdoc.cls'.
